/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MuPADConsole
extends WindowAdapter
implements WindowListener,
ActionListener,
Runnable {
    private JFrame frame;
    private JTextArea textArea;
    private Thread reader;
    private Thread reader2;
    private boolean quit;
    private boolean toFile;
    private final PipedInputStream pin;
    private final PipedInputStream pin2;

    public MuPADConsole(boolean bl) {
        block13: {
            PipedOutputStream pipedOutputStream;
            block12: {
                this.frame = new JFrame("MuPAD - Java Console");
                this.pin = new PipedInputStream();
                this.pin2 = new PipedInputStream();
                this.toFile = bl;
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension dimension2 = new Dimension(dimension.width / 3, dimension.height / 3);
                int n = dimension2.width / 4;
                int n2 = dimension2.height / 3;
                this.frame.setBounds(n, n2, dimension2.width, dimension2.height);
                this.textArea = new JTextArea();
                this.textArea.setEditable(true);
                this.textArea.setText(this.getJavaVersion());
                JButton jButton = new JButton("clear");
                this.frame.getContentPane().setLayout(new BorderLayout());
                this.frame.getContentPane().add((Component)new JScrollPane(this.textArea), "Center");
                this.frame.getContentPane().add((Component)jButton, "South");
                this.frame.addWindowListener(this);
                jButton.addActionListener(this);
                try {
                    pipedOutputStream = new PipedOutputStream(this.pin);
                    if (this.toFile) {
                        System.setOut(new PrintStream(new FileOutputStream("MuPADout.log")));
                    } else {
                        System.setOut(new PrintStream(pipedOutputStream, true));
                    }
                }
                catch (IOException iOException) {
                    if (!this.toFile) {
                        this.textArea.append("Couldn't redirect STDOUT to this console\n" + iOException.getMessage());
                    }
                }
                catch (SecurityException securityException) {
                    if (this.toFile) break block12;
                    this.textArea.append("Couldn't redirect STDOUT to this console\n" + securityException.getMessage());
                }
            }
            try {
                pipedOutputStream = new PipedOutputStream(this.pin2);
                if (this.toFile) {
                    System.setErr(new PrintStream(new FileOutputStream("MuPADerr.log")));
                } else {
                    System.setErr(new PrintStream(pipedOutputStream, true));
                }
            }
            catch (IOException iOException) {
                if (!this.toFile) {
                    this.textArea.append("Couldn't redirect STDERR to this console\n" + iOException.getMessage());
                }
            }
            catch (SecurityException securityException) {
                if (this.toFile) break block13;
                this.textArea.append("Couldn't redirect STDERR to this console\n" + securityException.getMessage());
            }
        }
        this.quit = false;
        this.reader = new Thread(this);
        this.reader.setDaemon(true);
        this.reader.start();
        this.reader2 = new Thread(this);
        this.reader2.setDaemon(true);
        this.reader2.start();
    }

    public void showWindow() {
        this.frame.setVisible(true);
        this.frame.toFront();
    }

    public void killWindow() {
        this.frame.setVisible(false);
        this.notifyAll();
        try {
            this.reader.join(1000L);
            this.pin.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.reader2.join(1000L);
            this.pin2.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frame.dispose();
    }

    @Override
    public synchronized void windowClosed(WindowEvent windowEvent) {
        this.frame.setVisible(false);
    }

    @Override
    public synchronized void windowClosing(WindowEvent windowEvent) {
        this.frame.setVisible(false);
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        this.textArea.setText(this.getJavaVersion());
    }

    private String getJavaVersion() {
        return "Used Java Version:\n" + System.getProperties().getProperty("java.vm.vendor") + "\n" + System.getProperties().getProperty("java.runtime.name") + "\n" + System.getProperties().getProperty("java.vm.name") + "\n" + System.getProperties().getProperty("java.vm.version") + "\n" + "====================================================================\n";
    }

    @Override
    public synchronized void run() {
        block12: {
            try {
                String string;
                while (Thread.currentThread() == this.reader) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.pin.available() != 0) {
                        string = this.readLine(this.pin);
                        if (!this.toFile) {
                            this.textArea.append(string);
                        }
                    }
                    if (!this.quit) continue;
                    return;
                }
                while (Thread.currentThread() == this.reader2) {
                    try {
                        this.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.pin2.available() != 0) {
                        string = this.readLine(this.pin2);
                        if (!this.toFile) {
                            this.textArea.append(string);
                        }
                    }
                    if (!this.quit) continue;
                    return;
                }
            }
            catch (Exception exception) {
                if (this.toFile) break block12;
                this.textArea.append("\nMuPAD Console reports an Internal error.");
                this.textArea.append("The error is: " + exception);
            }
        }
    }

    public synchronized String readLine(PipedInputStream pipedInputStream) throws IOException {
        int n;
        String string = "";
        while ((n = pipedInputStream.available()) != 0) {
            byte[] byArray = new byte[n];
            pipedInputStream.read(byArray);
            if (!(string = string + new String(byArray, 0, byArray.length)).endsWith("\n") && !string.endsWith("\r\n") && !this.quit) continue;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        new MuPADConsole(true);
    }
}

