/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import sun.plugin.cache.CacheUpdateHelper;

public class OldCacheEntry {
    private static final String INDEX_FILE_EXT = ".idx";
    private static final String DATA_FILE_EXT = ".zip";
    private static final String JAR_FILE_EXT = ".jar";
    private static final String JARJAR_FILE_EXT = ".jarjar";
    private static final int JAR = 1;
    private static final byte OLD_CACHE_VERSION = 16;
    private String url;
    private long expiration = 0L;
    private long lastModified = 0L;
    private String version = null;
    private File indexFile = null;
    private File dataFile = null;

    private OldCacheEntry() {
    }

    File getDataFile() {
        return this.dataFile;
    }

    URL getURL() {
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    long getExpiration() {
        return this.expiration;
    }

    long getLastModified() {
        return this.lastModified;
    }

    String getVersion() {
        if (this.version == null || this.version.equals("x.x.x.x")) {
            this.version = null;
        }
        return this.version;
    }

    static LinkedList getEntries() {
        LinkedList linkedList = new LinkedList();
        String string = File.separator;
        File file = new File(CacheUpdateHelper.getOldCacheDirectoryPath() + string + "jar");
        OldCacheEntry.getFileEntries(file, linkedList);
        File file2 = new File(CacheUpdateHelper.getOldCacheDirectoryPath() + string + "file");
        OldCacheEntry.getFileEntries(file2, linkedList);
        return linkedList;
    }

    private static void getFileEntries(File file, LinkedList linkedList) {
        if (file.exists()) {
            File[] fileArray = file.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    String string = file.getName();
                    return string.toLowerCase().endsWith(OldCacheEntry.INDEX_FILE_EXT);
                }
            });
            for (int i = 0; i < fileArray.length; ++i) {
                OldCacheEntry oldCacheEntry = null;
                try {
                    oldCacheEntry = OldCacheEntry.getDetails(fileArray[i]);
                }
                catch (IOException iOException) {
                    oldCacheEntry = null;
                }
                if (oldCacheEntry == null) continue;
                linkedList.add(oldCacheEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OldCacheEntry getDetails(File file) throws IOException {
        OldCacheEntry oldCacheEntry = null;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            if (randomAccessFile.readByte() == 16) {
                File file2;
                oldCacheEntry = new OldCacheEntry();
                oldCacheEntry.indexFile = file;
                oldCacheEntry.url = randomAccessFile.readUTF();
                oldCacheEntry.lastModified = randomAccessFile.readLong();
                oldCacheEntry.expiration = randomAccessFile.readLong();
                int n = randomAccessFile.readInt();
                if (n == 1) {
                    oldCacheEntry.version = randomAccessFile.readUTF();
                }
                if ((file2 = OldCacheEntry.getDataFileFromIndex(file, oldCacheEntry.url)).exists()) {
                    oldCacheEntry.dataFile = file2;
                } else {
                    oldCacheEntry = null;
                }
            }
        }
        finally {
            try {
                randomAccessFile.close();
                randomAccessFile = null;
            }
            catch (IOException iOException) {}
        }
        return oldCacheEntry;
    }

    private static final File getDataFileFromIndex(File file, String string) {
        String string2 = file.getName();
        string2 = string2.substring(0, string2.length() - INDEX_FILE_EXT.length());
        string2 = string2 + OldCacheEntry.getFileExtension(string);
        return new File(file.getParentFile(), string2);
    }

    private static final String getFileExtension(String string) {
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string2 = string.substring(n);
        }
        if (string2.equalsIgnoreCase(JAR_FILE_EXT) || string2.equalsIgnoreCase(JARJAR_FILE_EXT)) {
            string2 = DATA_FILE_EXT;
        }
        return string2;
    }

    public String toString() {
        return "url: " + this.getURL() + "\n" + "dataFile: " + this.getDataFile() + "\n" + "expiration: " + this.getExpiration() + "\n" + "lastModified: " + this.getLastModified() + "\n" + "version: " + this.getVersion() + "\n";
    }
}

